//
//  AAIIQACommUtil.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/12.
//

#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>

NS_ASSUME_NONNULL_BEGIN
__attribute__((visibility("default")))
@interface AAIIQACommUtil : NSObject

+ (BOOL)isSilent;
- (void)configPlayerVolume:(float)volume;
- (BOOL)isPlaying;
- (void)playAudio:(NSString *)audioName;

+ (NSString *)currLocale;
+ (NSString *)localStrForKey:(NSString *)key;
+ (UIImage *)imgWithName:(NSString *)imgName;

+ (void)resetLanCache;

+ (NSLayoutConstraint *)topContraintOf:(UIView *)rawView toSV:(UIView *)sv constant:(CGFloat)constant;
+ (NSLayoutConstraint *)leftContraintOf:(UIView *)rawView toSV:(UIView *)sv constant:(CGFloat)constant;
+ (NSLayoutConstraint *)rightContraintOf:(UIView *)rawView toSV:(UIView *)sv constant:(CGFloat)constant;
+ (NSLayoutConstraint *)bottomContraintOf:(UIView *)rawView toSV:(UIView *)sv constant:(CGFloat)constant;

+ (UIColor *)colorWithHexRGB:(NSInteger)hexRGB alpha:(CGFloat)alpha;

+ (UIFont *)fontWithSize:(CGFloat)size isBold:(BOOL)isBold;

+ (BOOL)isPortraitOrientation;
+ (NSArray *)avaliableCameraPositions;

+ (UIButton *)buttonWithTitle:(NSString *)title;
+ (UIButton *)borderButtonWithTitle:(NSString *)title;
+ (UIButton *)porButtonWithTitle:(NSString *)title img:(UIImage *)img;

// (lenMin, lenMax)
+ (CGSize)currScreenSize;

@end

NS_ASSUME_NONNULL_END
