//
//  AAIGlobalIQASDK+DefaultUI.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2025/7/17.
//

#import <AAIGlobalIQASDK/AAIIQASDKCore.h>

#if __has_include(<AAIGlobalIQAUI/AAIGlobalIQAConfig.h>)
#import <AAIGlobalIQAUI/AAIGlobalIQAConfig.h>
#else
#import "AAIGlobalIQAConfig.h"
#endif

#if __has_include(<AAIGlobalIQAUI/AAIGlobalIQAResult.h>)
#import <AAIGlobalIQAUI/AAIGlobalIQAResult.h>
#else
#import "AAIGlobalIQAResult.h"
#endif

NS_ASSUME_NONNULL_BEGIN

__attribute__((visibility("default")))
@interface AAIGlobalIQASDK(DefaultUI)

/**
 This method is used to initialize the SDK for the default UI module.

 @param config An AAIGlobalIQAConfig object.
 */
+ (void)initWithConfig:(AAIGlobalIQAConfig *)config;

/**
 Show SDK page. The SDK internally creates a navigationController and displays it full screen.

 @param rootVC A view controller that used to display the SDK navigationController.
 */
+ (void)startWithRootVC:(UIViewController *)rootVC;

/**
 Show SDK page and get result.
 This is a convenient method to get the result of the SDK process without setting AAIGlobalIQADelegate.

 @param rootVC A view controller that used to display the SDK navigationController.
 @param completionBlk A block object to be executed when the SDK process is completed.
 @since 1.4.1
 */
+ (void)startWithRootVC:(UIViewController *)rootVC completionBlk:(void (^)(AAIGlobalIQAResult *))completionBlk;

/**
 Create a full-screen presentation-style navigation controller with the SDK main page.
 If you want to display the SDK page in SwiftUI,  you can call this method and present the returned navigation controller.
 */
+ (UINavigationController *)createSDKNavigationController;

+ (AAIGlobalIQAConfig *)sdkConfig;

@end

NS_ASSUME_NONNULL_END
