//
//  AAIGlobalIQADelegate.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/20.
//

#import <Foundation/Foundation.h>

#if __has_include(<AAIGlobalIQAUI/AAIGlobalIQAResult.h>)
#import <AAIGlobalIQAUI/AAIGlobalIQAResult.h>
#else
#import "AAIGlobalIQAResult.h"
#endif

NS_ASSUME_NONNULL_BEGIN

@protocol AAIGlobalIQADelegate <NSObject>

@optional

/// Tells the delegate that the detection was successful in real-time scan mode.
/// @param contentView  The view of `AAIIQAScanController`
/// @param completionHandler A handler that your delegate method must call. Note this handler must be called on the main thread.
///
/// You can implement this method to perform your additional action. After your action is complete, you must call the completeHandler.
- (void)iqaOnDectionSuccess:(UIView *)contentView
          completionHandler:(void (^)(void))completionHandler __attribute__((unavailable("Use `iqaOnDetectionSuccess:completionHandler:` method of `AAIIQADetectionDelegate` instead")));

/// Tells the delegate that the detection timed out.
/// @param contentView The view of `AAIIQAScanController`
/// @param completionHandler A handler that your delegate method must call. Note this handler must be called on the main thread.
///
/// You can implement this method to perform your additional action. Note that if you implement this method, the default alert view will not displayed.
/// You can display your custom alert view in this method. After your action is complete, you must call the completeHandler.
- (void)iqaOnDetectionTimeout:(UIView *)contentView
            completionHandler:(void (^)(AAIIQADetectionTimeoutDisposition disposition))completionHandler __attribute__((unavailable("Use `iqaOnDetectionTimeout:consumeTimes:remainingRetryTimes:completionHandler:` method of `AAIIQADetectionDelegate` instead")));

@required

/// Tells the delegate that the detection is complete(success or failure).
/// @param result The detection result.
- (void)iqaOnDetectionComplete:(AAIGlobalIQAResult *)result;

@end

NS_ASSUME_NONNULL_END
