// swift-tools-version: 5.6
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
    name: "AAIGlobalIQAUI",
    defaultLocalization: "en",
    products: [
        // Products define the executables and libraries a package produces, making them visible to other packages.
        .library(
            name: "AAIGlobalIQAUI",
            targets: ["AAIGlobalIQAUI"])
    ],
    dependencies: [
        // Dependencies declare other packages that this package depends on.
        .package(name: "AAIGlobalIQASDK", path: "../AAIGlobalIQASDK")
    ],
    targets: [
        // Targets are the basic building blocks of a package. A target can define a module or a test suite.
        // Targets can depend on other targets in this package, and on products from dependencies.
        .target(
            name: "AAIGlobalIQAUI",
            dependencies: [
                .product(name: "AAIGlobalIQASDK", package: "AAIGlobalIQASDK")
            ],
            path: "Sources",
            resources: [
                .copy("Resources/AAIIQAAudio.bundle"),
                .copy("Resources/AAIIQALanguageString.bundle"),
                .copy("Resources/AAIIQAImgs.xcassets"),
                .process("Resources/PrivacyInfo.xcprivacy"),
            ],
            publicHeadersPath: "Classes/Public",
            cSettings: [
                            .headerSearchPath("Classes/UI/Config"),
                            .headerSearchPath("Classes/UI/Controller"),
                            .headerSearchPath("Classes/UI/Init"),
                            .headerSearchPath("Classes/UI/Model"),
                            .headerSearchPath("Classes/UI/Util"),
                            .headerSearchPath("Classes/UI/View"),
                        ]

        )
    ]
)
