//
//  ViewController.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2021/7/21.
//

import UIKit
import AAIGlobalIQAUI

class ViewController: UIViewController {
    
    private let _titleList: [String] = ["Default UI Test", "Custom UI 1 Test", "Custom UI 2 Test", "Custom UI 4 Test", "MyCameraViewDemo1"]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "SDK Demo"
        
        guard let sv = self.view else {
            return
        }
        
        let tbView = UITableView(frame: .zero, style: .plain)
        tbView.register(UITableViewCell.self, forCellReuseIdentifier: "a")
        tbView.dataSource = self
        tbView.delegate = self
        tbView.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(tbView)
        
        let constr: [NSLayoutConstraint] = [
            AAIIQACommUtil.topContraint(of: tbView, toSV: sv, constant: 0),
            AAIIQACommUtil.leftContraint(of: tbView, toSV: sv, constant: 0),
            AAIIQACommUtil.rightContraint(of: tbView, toSV: sv, constant: 0),
            AAIIQACommUtil.bottomContraint(of: tbView, toSV: sv, constant: 0)
        ]
        NSLayoutConstraint.activate(constr)
    }
}

extension ViewController: UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return _titleList.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "a", for: indexPath)
        cell.textLabel?.text = _titleList[indexPath.row]
        return cell
    }
}


extension ViewController: UITableViewDelegate {
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        switch indexPath.row {
        case 0:
            let vc = AAIDefaultUsageDemoViewController()
            vc.title = _titleList[indexPath.row]
            self.navigationController?.pushViewController(vc, animated: true)
        case 1:
            let vc = AAICustomUIDemo1ViewController()
            vc.title = _titleList[indexPath.row]
            self.navigationController?.pushViewController(vc, animated: true)
        case 2:
            let vc = AAICustomUIDemo2ViewController()
            vc.title = _titleList[indexPath.row]
            self.navigationController?.pushViewController(vc, animated: true)
        case 3:
            let vc = AAICustomUIDemo4ViewController()
            vc.title = _titleList[indexPath.row]
            self.navigationController?.pushViewController(vc, animated: true)
        case 4:
            let vc = AAICameraViewDemo1ViewController()
            vc.title = _titleList[indexPath.row]
            self.navigationController?.pushViewController(vc, animated: true)
        default:
            let _ = ""
        }
    }
}
