//
//  AAICustomOverlayView4.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2023/8/1.
//

import Foundation
import AAIGlobalIQAUI

class AAICustomOverlayView4: AAIIQAOverlayView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        // You can add your custom subviews. For example, add an image view.
        // Or you can override the `drawRect:` method to draw your custom graph.
        // Because the super class AAIIQAOverlayView draw the viewfinder in `drawRect:` method,
        // if you don't want the default viewfinder style, you should always override the `drawRect:` method.
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // You can override the `drawRect` method to draw your custom graph.
    override func draw(_ rect: CGRect) {
        let context = UIGraphicsGetCurrentContext()
        
        let uiConfig = AAIGlobalIQASDK.sdkConfig().uiConfig
        context?.saveGState()
        
        let borderLineWidth: CGFloat = 2;
        let rectPath = UIBezierPath(rect: rect)
        context?.addPath(rectPath.cgPath)
        context?.setLineWidth(borderLineWidth)
        context?.setLineCap(.square)
        context?.setStrokeColor(uiConfig.viewfinderColor.cgColor)
        context?.strokePath()
        
        let lineLength: CGFloat = 20
        let origin = rect.origin;
        let size = rect.size;
        
        let lineWidth: CGFloat = 6.0
        context?.setLineWidth(lineWidth)
        
        // Left top (bottom > top -> right)
        context?.move(to: CGPoint(x: origin.x, y: origin.y + lineLength))
        context?.addLine(to: CGPoint(x: origin.x, y: origin.y))
        context?.addLine(to: CGPoint(x: origin.x + lineLength, y: origin.y))
     
        // Left bottom (top > bottom -> right)
        context?.move(to: CGPoint(x: origin.x, y: origin.y + size.height - lineLength))
        context?.addLine(to: CGPoint(x: origin.x, y: origin.y + size.height))
        context?.addLine(to: CGPoint(x: origin.x + lineLength, y: origin.y + size.height))
     
        // Right bottom (left -> right -> top)
        context?.move(to: CGPoint(x: origin.x + size.width - lineLength, y: origin.y + size.height))
        context?.addLine(to: CGPoint(x: origin.x + size.width, y: origin.y + size.height))
        context?.addLine(to: CGPoint(x: origin.x + size.width, y: origin.y + size.height - lineLength))
             
        // Right top (bottom -> top -> left)
        context?.move(to: CGPoint(x: origin.x + size.width, y: origin.y + lineLength))
        context?.addLine(to: CGPoint(x: origin.x + size.width, y: origin.y))
        context?.addLine(to: CGPoint(x: origin.x + size.width - lineLength, y: origin.y))
        
        context?.strokePath()
    }

}
