//
//  AAICustomLoadingView4.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2023/8/1.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomLoadingView4: UIView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.layer.cornerRadius = 8
        self.backgroundColor = .white
        
        let contentView = UIView()
        contentView.translatesAutoresizingMaskIntoConstraints = false
        
        let imgView = UIImageView(image: UIImage(named: "c4_loading"))
        imgView.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(imgView)
        
        let label = UILabel()
        label.text = "Loading..."
        label.font = AAIIQACommUtil.font(withSize: 14, isBold: true)
        label.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(label)
        
        let contentCons: [NSLayoutConstraint] = [
            imgView.leftAnchor.constraint(equalTo: contentView.leftAnchor),
            imgView.centerYAnchor.constraint(equalTo: contentView.centerYAnchor),
            label.leftAnchor.constraint(equalTo: imgView.rightAnchor, constant: 8),
            label.rightAnchor.constraint(equalTo: contentView.rightAnchor),
            label.centerYAnchor.constraint(equalTo: contentView.centerYAnchor),
        ]
        NSLayoutConstraint.activate(contentCons)
        
        self.addSubview(contentView)
        let cons: [NSLayoutConstraint] = [
            contentView.heightAnchor.constraint(equalToConstant: 44),
            contentView.topAnchor.constraint(equalTo: self.topAnchor, constant: 10),
            contentView.bottomAnchor.constraint(equalTo: self.bottomAnchor, constant: -10),
            contentView.leftAnchor.constraint(equalTo: self.leftAnchor, constant: 10),
            contentView.rightAnchor.constraint(equalTo: self.rightAnchor, constant: -10)
        ]
        NSLayoutConstraint.activate(cons)
        
        let animation = CABasicAnimation(keyPath: "transform")
        animation.toValue = CATransform3DMakeRotation(Double.pi, 0, 0, 1)
        animation.duration = 0.5
        animation.isCumulative = true
        animation.repeatCount = HUGE
        imgView.layer.add(animation, forKey: nil)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
