//
//  AAICustomUIDemo4ViewController.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2023/7/28.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomUIDemo4ViewController: BaseDemoViewController {
    override func tapSDKBtnAction() {
        let config = AAIGlobalIQAConfig.initWithRegion(_reginList[_currReginIdx], cardType: _cardTypeList[_currCardTypeIdx], cardSide: _cardSideList[_currCardSideIdx])
        config.delegate = self;
        config.callbackAfterPageDismissed = true;
        
        // Configure SDK operation mode
        config.operatingMode = _opModeList[_currOpModeIdx]
        config.uiConfig.tipViewVisible = false
        config.uiConfig.topDescViewVisible = false
        config.uiConfig.navBarVisible = false
        config.uiConfig.takePhotoTipViewVisible = false
        config.uiConfig.takePhotoButtonVisible = false
        config.uiConfig.timerLabelVisible = false
        
        // Configure SDK UI
        config.uiConfig.pageBackgroundColor = .white
        config.uiConfig.viewfinderColor = AAIIQACommUtil.color(withHexRGB: 0x25BC73, alpha: 1)
        config.uiConfig.orientation = .portrait
        
        config.detectionTimeoutInterval = 5
//        config.languageLprojName = "id"
        
        // config.maxRetryTimes = 2

        // Set the left and right margin on x-axis of cameraView when device in portrait mode.
        config.uiConfig.cameraViewMarginLRInPortraitMode = NSNumber(value: 15)
    
        // If you want to add custom UI on the SDK page, just register the custom class to the SDK.
        
        // You can customize the scan page UI by inheriting `AAIIQAScanController` class,
        // then register your custom class to the sdk.
        config.register(AAICustomScanController4.self, for: .scanController)
        
        // You can customize the preview the photos taken page UI by inheriting `AAIIQAPreviewImgController` class,
        // then register your custom class to the sdk.
        config.register(AAICustomPreviewImgController4.self, for: .previewImgController)

        // You can customize the camera overlay view UI of `AAIIQAScanController` page by inheriting `AAIIQAOverlayView` class,
        // then register your custom class to the sdk.
        config.register(AAICustomOverlayView4.self, for: .overlayViewOfScanVC)
        
        /* imageName list:
        advance_iqa_scan: An image to show the scan animation.
        advance_iqa_tip_capture: The icon in the countdown pop-up view after the scan times out.
        iqa_back: Icon of navigation bar back button.
        iqa_land_confirm: Confirm button icon in landscape take photo mode.
        iqa_land_retake: Retake button icon in landscape take photo mode.
        iqa_light_off: Icon of flashlight off button.
        iqa_light_on: Icon of flashlight on button.
        iqa_scan_processing: The icon displayed at the bottom of the vertical screen (local string key is: "hold_phone").
        iqa_scan_successfully: The icon displayed at the bottom of the vertical screen (local string key is: "iqa_scan_successfully").
        iqa_scan_warning: The icon displayed at the bottom of the vertical screen (local string key is: "iqa_card_poor_quality").
        iqa_take_photo_tip: The tip icon displayed at the bottom of the viewfinder view (local string key is: "iqa_take_photo_tips").
        iqa_take_photo: Icon of take photo button.
        iqa_transform_camera: Icon of switch camera button.
        */
        
        // You can implement this block to customize the images used in the SDK.
        config.uiConfig.loadImage = {(imgName, img) -> UIImage in
            if imgName == "advance_iqa_scan" {
                return UIImage(named: "c4_scan")!
            }
            return img
        }
        
        
        /*
        // You can implement this block to customize the localized strings used in the SDK.
        // For all available keys, see "AAIGlobalIQASDK.framework/Assets.bundle/AAIIQALanguageString.bundle/en.lproj/Localizable.strings"
        config.uiConfig.loadLocalizedString = {(key, value, language) -> String in
            if key == "iqa_top_desc" && language == "en" {
                return "My test string"
            }
            
            return value
        }
         */
        // 2. Init SDK
        AAIGlobalIQASDK.initWith(config);
        /*
         The license content is obtained by your server calling our openapi.
         In order to demonstrate this SDK, we directly put the content of the license into the file,
         in fact, you should call your server api to get the license content.
         Note that the "setLicenseAndCheck" method MUST BE CALLED before calling "start(WithRootVC:)".
         */
        guard let path = Bundle.main.path(forResource: "SDK-DEMO-LICENSE.txt", ofType: nil) else {
            print("SDK-DEMO-LICENSE file not exist!")
            return
        }
        var demoLicenseContent = ""
        do {
            var content = try String(contentsOfFile:path, encoding: String.Encoding.utf8)
            content = content.trimmingCharacters(in: .whitespacesAndNewlines)
            demoLicenseContent = content
        } catch {}

        let result = AAIGlobalIQASDK.setLicenseAndCheck(demoLicenseContent)
        if result == "SUCCESS" {
            // 3. Show SDK page
            AAIGlobalIQASDK.start(withRootVC: self)
        } else {
            _tv?.text = result
            if result == "LICENSE_EXPIRE" {
                print("LICENSE_EXPIRE: please call your server's api to generate a new license")
            } else if result == "APPLICATION_ID_NOT_MATCH" {
                print("APPLICATION_ID_NOT_MATCH: please bind your app's bundle identifier on our cms website, then recall your server's api to generate a new license")
            } else {
                print("\(result)")
            }
        }
        
        
    }
}

extension AAICustomUIDemo4ViewController: AAIGlobalIQADelegate {
    func iqa(onDetectionComplete result: AAIGlobalIQAResult) {
        processIQAResult(result)
    }
}

