//
//  CustomOverlayView1.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/30.
//
import UIKit
import AAIGlobalIQAUI

class AAICustomOverlayView2: AAIIQAOverlayView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        // You can add your custom subviews. For example, add an image view.
        // Or you can override the `drawRect:` method to draw your custom graph.
        // Because the super class AAIIQAOverlayView draw the viewfinder in `drawRect:` method,
        // if you don't want the default viewfinder style, you should always override the `drawRect:` method.
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // You can override the `drawRect` method to draw your custom graph.
    override func draw(_ rect: CGRect) {
        let context = UIGraphicsGetCurrentContext()
        
        let borderRadius: CGFloat = 20
        let lineWidth: CGFloat = 6
        let borderColor = AAIGlobalIQASDK.sdkConfig().uiConfig.viewfinderColor
        
        let halfLineWidth = lineWidth/2
        context?.saveGState()
        context?.setFillColor(self.maskColor.cgColor)
        
        let maskPath: UIBezierPath = UIBezierPath(rect: rect)
        let innerRect = rect.insetBy(dx: halfLineWidth, dy: halfLineWidth)
        let innerRectPath = UIBezierPath(roundedRect: innerRect, cornerRadius: borderRadius)
        maskPath.append(innerRectPath)
        maskPath.usesEvenOddFillRule = true
        context?.addPath(maskPath.cgPath)
        context?.fillPath(using: .evenOdd)
        context?.restoreGState()
        
        context?.beginPath()
        context?.setLineWidth(lineWidth)
        
        let borderPath = UIBezierPath(roundedRect: innerRect, cornerRadius: borderRadius)
        context?.addPath(borderPath.cgPath)
        context?.setStrokeColor(borderColor.cgColor)
        context?.strokePath()
    }

}

