//
//  AAICustomUIDemo1ViewController.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/29.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomUIDemo1ViewController: BaseDemoViewController {
    override func tapSDKBtnAction() {
        let config = AAIGlobalIQAConfig.initWithRegion(_reginList[_currReginIdx], cardType: _cardTypeList[_currCardTypeIdx], cardSide: _cardSideList[_currCardSideIdx])
        config.delegate = self;
        config.callbackAfterPageDismissed = true;
        
        // Configure SDK operation mode
        config.operatingMode = _opModeList[_currOpModeIdx]
        
        // Configure SDK UI
//        config.uiConfig.flipCameraBtnVisible = false
//        config.uiConfig.lightBtnVisible = false
        
        // Whether the show the timer label in the upper right corner of the view. Default is YES.
//        config.uiConfig.timerLabelVisible = false
        
//        config.uiConfig.navBarTitleTextColor = .red
//        config.uiConfig.navBarBackgroundColor = .white
//        config.uiConfig.statusBarStyle = .default
//        config.uiConfig.tipIconVisible = false
//        config.uiConfig.pageBackgroundColor = .red
//        config.uiConfig.viewfinderColor = .green
//        config.uiConfig.primaryTextColor = .yellow
//        config.uiConfig.orientation = .portrait
//        config.uiConfig.takePhotoTipTextColor = .white
//        config.uiConfig.takePhotoTipBackgroundColor = .blue
//        config.uiConfig.previewPhotoTipBackgroundColor = .blue
//        config.uiConfig.previewPhotoTipTextColor = .white
//        config.uiConfig.toolButtonThemeColor = .blue
//        config.detectionTimeoutInterval = 20
//        config.returnEmptyOfOCR = NO
        config.languageLprojName = "id"
        
        /*
        // Set the left and right margin on x-axis of cameraView when device in portrait mode.
        config.uiConfig.cameraViewMarginLRInPortraitMode = NSNumber(value: 12)
        */
        
        /*
        // The duration of the alert view displayed when SDK are about to enter the photo mode,
        // the default is 3s, if set to 0, the alert view will not be displayed.
        config.takePhotoAlertViewTimeoutInterval = 0
        */
        
        // If you want to add custom UI on the SDK page, just register the custom class to the SDK.
        
        
        // You can customize the scan page UI by inheriting `AAIIQAScanController` class,
        // then register your custom class to the sdk.
        config.register(AAICustomScanController1.self, for: .scanController)
        
        
        // You can customize the preview the photos taken page UI by inheriting `AAIIQAPreviewImgController` class,
        // then register your custom class to the sdk.
        config.register(AAICustomPreviewImgController1.self, for: .previewImgController)
        
        
        // You can customize the camera overlay view UI of `AAIIQAScanController` page by inheriting `AAIIQAOverlayView` class,
        // then register your custom class to the sdk.
        config.register(AAICustomOverlayView1.self, for: .overlayViewOfScanVC)
        
        
        // You can customize the camera overlay view UI of `AAIIQAPreviewImgController` page by inheriting `AAIIQAOverlayView` class,
        // then register your custom class to the sdk.
        config.register(AAICustomOverlayView1.self, for: .overlayViewOfPreviewImgVC)

        
        /* imageName list:
        advance_iqa_scan: An image to show the scan animation.
        advance_iqa_tip_capture: The icon in the countdown pop-up view after the scan times out.
        iqa_back: Icon of navigation bar back button.
        iqa_land_confirm: Confirm button icon in landscape take photo mode.
        iqa_land_retake: Retake button icon in landscape take photo mode.
        iqa_light_off: Icon of flashlight off button.
        iqa_light_on: Icon of flashlight on button.
        iqa_scan_processing: The icon displayed at the bottom of the vertical screen (local string key is: "hold_phone").
        iqa_scan_successfully: The icon displayed at the bottom of the vertical screen (local string key is: "iqa_scan_successfully").
        iqa_scan_warning: The icon displayed at the bottom of the vertical screen (local string key is: "iqa_card_poor_quality").
        iqa_take_photo_tip: The tip icon displayed at the bottom of the viewfinder view (local string key is: "iqa_take_photo_tips").
        iqa_take_photo: Icon of take photo button.
        iqa_transform_camera: Icon of switch camera button.
        */
        /*
        // You can implement this block to customize the images used in the SDK.
        config.uiConfig.loadImage = {(imgName, img) -> UIImage in
            if imgName == "iqa_scan_successfully" {
                return UIImage(named: "ok")!
            }
            return img
        }
        */
        
        /*
        // You can implement this block to customize the localized strings used in the SDK.
        // For all available keys, see "AAIGlobalIQASDK.framework/Assets.bundle/AAIIQALanguageString.bundle/en.lproj/Localizable.strings"
        config.uiConfig.loadLocalizedString = {(key, value, language) -> String in
            if key == "iqa_top_desc" && language == "en" {
                return "My test string"
            }
            
            return value
        }
         */
        // 2. Init SDK
        AAIGlobalIQASDK.initWith(config);
        /*
         The license content is obtained by your server calling our openapi.
         In order to demonstrate this SDK, we directly put the content of the license into the file,
         in fact, you should call your server api to get the license content.
         Note that the "setLicenseAndCheck" method MUST BE CALLED before calling "start(WithRootVC:)".
         */
        guard let path = Bundle.main.path(forResource: "SDK-DEMO-LICENSE.txt", ofType: nil) else {
            print("SDK-DEMO-LICENSE file not exist!")
            return
        }
        var demoLicenseContent = ""
        do {
            var content = try String(contentsOfFile:path, encoding: String.Encoding.utf8)
            content = content.trimmingCharacters(in: .whitespacesAndNewlines)
            demoLicenseContent = content
        } catch {}

        let result = AAIGlobalIQASDK.setLicenseAndCheck(demoLicenseContent)
        if result == "SUCCESS" {
            // 3. Show SDK page
            AAIGlobalIQASDK.start(withRootVC: self)
        } else {
            _tv?.text = result
            if result == "LICENSE_EXPIRE" {
                print("LICENSE_EXPIRE: please call your server's api to generate a new license")
            } else if result == "APPLICATION_ID_NOT_MATCH" {
                print("APPLICATION_ID_NOT_MATCH: please bind your app's bundle identifier on our cms website, then recall your server's api to generate a new license")
            } else {
                print("\(result)")
            }
        }
        
        
    }
}

extension AAICustomUIDemo1ViewController: AAIGlobalIQADelegate {
    func iqa(onDetectionComplete result: AAIGlobalIQAResult) {
        processIQAResult(result)
    }
}
