//
//  MyCameraView1ViewController.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2024/5/24.
//

import UIKit
import AAIGlobalIQASDK
import AAIGlobalIQAUI

class MyCameraDemo1ViewController : UIViewController {
    
    private lazy var startScanModeBtn:UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("Start scan mode", for: .normal)
        btn.setTitleColor(.red, for: .normal)
        btn.backgroundColor = .lightGray
        btn.translatesAutoresizingMaskIntoConstraints = false
        return btn
    }()
    
    private lazy var startPhotoModeBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("Start Photo mode", for: .normal)
        btn.setTitleColor(.red, for: .normal)
        btn.backgroundColor = .lightGray
        btn.translatesAutoresizingMaskIntoConstraints = false
        return btn
    }()
    
    private lazy var warnMsgLabel: UILabel = {
        let label = UILabel()
        label.textColor = .black
        label.numberOfLines = 0
        label.translatesAutoresizingMaskIntoConstraints = false
        return label
    }()
    
    private lazy var takePhotoBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("takePhoto", for: .normal)
        btn.setTitleColor(.black, for: .normal)
        btn.backgroundColor = .lightGray
        btn.translatesAutoresizingMaskIntoConstraints = false
        return btn
    }()
    
    private var retakePhotoBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("retake", for: .normal)
        btn.setTitleColor(.black, for: .normal)
        btn.backgroundColor = .lightGray
        btn.translatesAutoresizingMaskIntoConstraints = false
        return btn
    }()
    
    private lazy var loadingView: UIActivityIndicatorView = {
        let view = UIActivityIndicatorView()
        view.color = .white
        view.backgroundColor = .black
        view.hidesWhenStopped = true
        return view
    }()
    
    private lazy var scanConfig: AAIIQACameraWrapperViewScanConfig = {
        let config = AAIIQACameraWrapperViewScanConfig()
        config.region = "ID"
        config.cardType = .idCard
        config.cardSide = .front
        config.detectionTimeoutInterval = 20
        return config
    }()
    
    private lazy var photoConfig: AAIIQACameraWrapperViewPhotoConfig = {
        let config = AAIIQACameraWrapperViewPhotoConfig()
        config.region = "ID"
        config.cardType = .idCard
        config.cardSide = .front
        return config
    }()
    
    private var cameraView: AAIIQACameraWrapperView?
    private var previewImg: UIImage?
        
    public var completeBlk: ((MyCameraDemo1ViewController, AAIGlobalIQAResultProtocol) -> Void)?
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .white
        
        self.view.addSubview(self.startScanModeBtn)
        self.view.addSubview(self.startPhotoModeBtn)
        
        let cameraView = AAIIQACameraWrapperView()
        cameraView.translatesAutoresizingMaskIntoConstraints = false
        self.view.addSubview(cameraView)
        self.cameraView = cameraView
        
        self.view.addSubview(self.warnMsgLabel)
        
        self.view.addSubview(self.retakePhotoBtn)
        self.view.addSubview(self.takePhotoBtn)
        
        let cons: [NSLayoutConstraint] = [
            
            startScanModeBtn.topAnchor.constraint(equalTo: self.view.topAnchor, constant: 100),
            startScanModeBtn.heightAnchor.constraint(equalToConstant: 50),
            startScanModeBtn.widthAnchor.constraint(equalToConstant: 150),
            startScanModeBtn.leftAnchor.constraint(equalTo: self.view.leftAnchor, constant: 20),
            
            startPhotoModeBtn.topAnchor.constraint(equalTo: startScanModeBtn.topAnchor),
            startPhotoModeBtn.heightAnchor.constraint(equalToConstant: 50),
            startPhotoModeBtn.widthAnchor.constraint(equalToConstant: 150),
            startPhotoModeBtn.rightAnchor.constraint(equalTo: self.view.rightAnchor, constant: -20),
            
            cameraView.topAnchor.constraint(equalTo: startScanModeBtn.bottomAnchor, constant: 10),
            cameraView.widthAnchor.constraint(equalTo:self.view.widthAnchor, multiplier: 0.9),
            cameraView.heightAnchor.constraint(equalTo:cameraView.widthAnchor, multiplier: 0.625),
            cameraView.centerXAnchor.constraint(equalTo: self.view.centerXAnchor),
            
            retakePhotoBtn.topAnchor.constraint(equalTo: cameraView.bottomAnchor, constant: 50),
            retakePhotoBtn.heightAnchor.constraint(equalToConstant: 50),
            retakePhotoBtn.widthAnchor.constraint(equalToConstant: 100),
            retakePhotoBtn.leftAnchor.constraint(equalTo: self.view.leftAnchor, constant: 20),
            
            takePhotoBtn.topAnchor.constraint(equalTo: cameraView.bottomAnchor, constant: 50),
            takePhotoBtn.heightAnchor.constraint(equalToConstant: 50),
            takePhotoBtn.widthAnchor.constraint(equalToConstant: 100),
            takePhotoBtn.rightAnchor.constraint(equalTo: self.view.rightAnchor, constant: -20),
            
            warnMsgLabel.topAnchor.constraint(equalTo: retakePhotoBtn.bottomAnchor, constant: 10),
            warnMsgLabel.leftAnchor.constraint(equalTo: cameraView.leftAnchor, constant: 0),
            warnMsgLabel.rightAnchor.constraint(equalTo: cameraView.rightAnchor, constant: 0),
        ]
        NSLayoutConstraint.activate(cons)
        
        
        self.startScanModeBtn.addTarget(self, action: #selector(tapStartScanModeBtnAction), for: .touchUpInside)
        self.startPhotoModeBtn.addTarget(self, action: #selector(tapStartPhotoModeBtnAction), for: .touchUpInside)
        self.retakePhotoBtn.addTarget(self, action: #selector(tapRetakePhotoBtnAction), for: .touchUpInside)
        self.takePhotoBtn.addTarget(self, action: #selector(tapTakePhotoBtnAction), for: .touchUpInside)
        
        self.retakePhotoBtn.isHidden = true
        self.takePhotoBtn.isHidden = true
        
    }
    
    @objc func tapStartScanModeBtnAction() {
        takePhotoBtn.isHidden = true
        retakePhotoBtn.isHidden = true
        previewImg = nil
        warnMsgLabel.text = ""
        warnMsgLabel.isHidden = false
        
        scanConfig.region = "id"
        scanConfig.cardType = .idCard
        scanConfig.cardSide = .front
        scanConfig.detectionTimeoutInterval = 20
        cameraView?.startScanMode(with: scanConfig, delegate: self)
    }
    
    @objc func tapStartPhotoModeBtnAction() {
        warnMsgLabel.isHidden = true
        previewImg = nil
        takePhotoBtn.setTitle("TakePhoto", for: .normal)
        retakePhotoBtn.isHidden = true
        
        cameraView?.startPhotoMode(with: photoConfig, delegate: self)
    }
    
    @objc func tapTakePhotoBtnAction() {
        if let _ = previewImg {
            cameraView?.useCapturedPhoto()
        } else {
            cameraView?.capturePhoto();
        }
    }
    
    @objc func tapRetakePhotoBtnAction() {
        cameraView?.discardCapturedPhoto()
        previewImg = nil
        
        takePhotoBtn.setTitle("TakePhoto", for: .normal)
    }
    
    private func showLoadingView() {
        if loadingView.superview == nil {
            loadingView.translatesAutoresizingMaskIntoConstraints = false
            self.view.addSubview(loadingView)
            let cons: [NSLayoutConstraint] = [
                loadingView.widthAnchor.constraint(equalToConstant: 100),
                loadingView.heightAnchor.constraint(equalToConstant: 100),
                loadingView.centerXAnchor.constraint(equalTo: self.view.centerXAnchor),
                loadingView.centerYAnchor.constraint(equalTo: self.view.centerYAnchor),
            ]
            NSLayoutConstraint.activate(cons)
        }
        loadingView.isHidden = false
        loadingView.startAnimating()
    }
    
    private func dismissLoadingView() {
        loadingView.isHidden = true
    }
    
    override func willTransition(to newCollection: UITraitCollection, with coordinator: UIViewControllerTransitionCoordinator) {
        cameraView?.willTransition(to: UIDevice.current.orientation)
        super.willTransition(to: newCollection, with: coordinator)
    }
}

extension MyCameraDemo1ViewController: AAIIQACameraWrapperViewScanModeDelegate {
    
    func iqaOnScanStart() {
        print("[callback][iqaOnScanStart]")
    }
    
    func iqa(onScanWarnCodeChanged warnCode: AAIIQAWarnCode) {
        print("[callback][onScanWarn][\(warnCode.rawValue)]")
        var stateKey: String?
        var msg: String?
        switch warnCode {
        case .noCard:
            stateKey = "no_card"
            msg = "No document is detected"
        case .tooSmallCard:
            stateKey = "too_small_card"
            msg = "Document is too small"
        case .edgeCross:
            stateKey = "iqa_min_gap_ratio"
            msg = "The document is incomplete\nplease make sure the document in the center with the edges aligned"
        case .cardPoorQuality:
            stateKey = "iqa_card_poor_quality"
            msg = "Document is too dim/blurred/overexposed"
        case .good:
            stateKey = "hold_phone"
            msg = "Please hold the phone steadily"
        case .hasOccluded:
            stateKey = "card_has_occluded"
            msg = "Please keep your ID card unobstructed"
        case .unspecified:
            let _ = "";
        @unknown default:
            fatalError("Unknown AAIIQAWarnCode!")
        }
        
        if let msg = msg {
            // The class AAIIQACommUtil is in the AAIGlobalIQAUI module.
            self.warnMsgLabel.text = msg
        } else {
            self.warnMsgLabel.text = nil
        }
    }
    
    func iqa(onScanSuccess rawImage: UIImage?) {
        print("[callback][onScanSuccess]")
        // Note that you should obtain the original scanned image from the `iqa(onScanModeComplete:)` method
    }
    
    func iqa(onScanRemainingSecondsChanged remainSeconds: Int, totalSeconds: Int) {
        print("[callback][onDetectionRemainTimeChanged: \(remainSeconds)/\(totalSeconds)]")
    }
    
    func iqa(onScanModeComplete result: AAIGlobalIQAResultProtocol) {
        print("[callback][onScanModeComplete]")
        if result.errorCode == "SCAN_TIMEOUT" {
            self.warnMsgLabel.text = nil
            
            // Demo: Enter photoMode
            self.cameraView?.startPhotoMode(with: photoConfig, delegate: self)
            
            /*
            // Demo: Retry scan
            self.cameraView?.startScanMode(with: scanConfig, delegate: self)
             */
            return;
        }
        
        // Show
        self.cameraView?.stopRunning()
        
        completeBlk?(self, result);
    }
}

extension MyCameraDemo1ViewController: AAIIQACameraWrapperViewPhotoModeDelegate {
    func iqaOnPhotoModeStart() {
        print("[callback][iqaOnPhotoModeStart]")
        takePhotoBtn.isHidden = false
    }
    
    func iqa(onCapturePhotoDone capturedImage: UIImage?, previewImage: UIImage) {
        print("[callback][onCapturePhotoDone]")
        
        takePhotoBtn.setTitle("Continue", for: .normal)
        retakePhotoBtn.isHidden = false
        self.previewImg = previewImage
    }
    
    func iqa(onPhotoModeComplete result: AAIGlobalIQAResultProtocol) {
        print("[callback][onPhotoModeComplete]")
        // Show
        self.cameraView?.stopRunning()
        
        completeBlk?(self, result);
    }
}

extension MyCameraDemo1ViewController: AAIIQACameraWrapperViewAuthDelegate {
    func iqaOnAuthCheckStart() {
        print("[callback][iqaOnAuthCheckStart]")
        self.showLoadingView()
        self.view.isUserInteractionEnabled = false
    }
    
    func iqa(onAuthCheckFinish error: Error?) {
        print("[callback][onAuthCheckFinish]")
        self.dismissLoadingView()
        self.view.isUserInteractionEnabled = true
    }
    
    func iqaOnUploadDataStart() {
        print("[callback][iqaOnUploadDataStart]")
        self.showLoadingView()
        self.view.isUserInteractionEnabled = false
    }
    
    func iqa(onUploadDataFinish error: Error?) {
        print("[callback][onUploadDataFinish][\(String(describing: error))]")
        self.dismissLoadingView()
        self.view.isUserInteractionEnabled = true
    }
}
