// swift-tools-version: 5.6
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

// If you want to minimize the size of the package, you can exclude optional dependencies according to your needs.
// Set the flags to false to exclude optional dependencies

var mainTargetDeps: [PackageDescription.Target] = [
  .binaryTarget(
    name: "AAIGlobalIQASDK",
    path: "Frameworks/AAIGlobalIQASDK.xcframework"),

  .binaryTarget(
    name: "AAINetwork",
    url: "https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-libraries/AAINetwork/AAINetwork-V1.0.4.xcframework.zip",
    checksum: "676c14e1e823ca30a5c7ac6f0cc46c2495ae642a5e7bee5fc39f2e6b5d1c8d31"),

  .binaryTarget(
    name: "AAICore",
    url: "https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-libraries/AAICore/1.0.1/AAICore-V1.0.1.xcframework.zip",
    checksum: "8fa1346a390eccb7d4bc730ec090f76d1dd67515867c2bc321f71b79f5962671"),
]

let package = Package(
  name: "AAIGlobalIQASDK",
  products: [
    // Products define the executables and libraries a package produces, making them visible to other packages.
    .library(
      name: "AAIGlobalIQASDK",
      targets: ["AAIGlobalIQASDK", "AAINetwork", "AAICore"])
  ],
  targets: mainTargetDeps
)
