//
//  AAIIQAConstant.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/4.
//

#import <Foundation/Foundation.h>

#ifndef AAIIQAConstant_h
#define AAIIQAConstant_h

typedef NS_ENUM(NSInteger, AAIIQACardType) {
    AAIIQACardTypeIDCard = 0,
    AAIIQACardTypeDrivingLicense = 1,
    AAIIQACardTypeUMID = 2,
    AAIIQACardTypeSSS = 3,
    AAIIQACardTypeTIN = 4,
    AAIIQACardTypePassport = 5,
    AAIIQACardTypeVOTERID = 6,
    AAIIQACardTypeNATIONALID = 7,
    AAIIQACardTypePRC = 8,
    AAIIQACardTypePAGIBG __deprecated_enum_msg("Use AAIIQACardTypePAGIBIG.") = 9,
    AAIIQACardTypePOSTALID = 10,
    AAIIQACardTypePAGIBIG = 11
};

typedef NS_ENUM(NSInteger, AAIIQACardSide) {
    AAIIQACardSideFront = 0,
    AAIIQACardSideBack = 1,
};

typedef NS_ENUM(NSInteger, AAIIQAWarnCode) {
    AAIIQAWarnCodeUnspecified = -1,
    AAIIQAWarnCodeNoCard = 0,
    AAIIQAWarnCodeTooSmallCard = 1,
    AAIIQAWarnCodeEdgeCross = 2,
    AAIIQAWarnCodeCardPoorQuality = 3,
    AAIIQAWarnCodeGood = 4,
    AAIIQAWarnCodeHasOccluded = 5,
    AAIIQAWarnCodeCardGlossy = 6,
};

typedef NS_ENUM(NSInteger, AAIIQAErrorCode) {
    AAIIQAErrorCodeUnspecified = -2,
    
    /// Other error code
    AAIIQAErrorCodeOther = -1,
    
    /// CAMERA_OPEN_FAILED
    AAIIQAErrorCodeCameraOpenFailed = 0,
    
    /// USER_GIVE_UP
    AAIIQAErrorCodeUserGiveUp = 1,
    
    /// DEVICE_NOT_SUPPORT
    AAIIQAErrorCodeDeviceNotSupport = 2,
    
    /// CAMERA_PERMISSION_DENIED
    AAIIQAErrorCodeCameraPermissionDenied = 3,
    
    /// MODEL_ERROR
    AAIIQAErrorCodeModelError = 4,
    
    /// NETWORK_REQUEST_FAILED
    AAIIQAErrorCodeNetworkRequstFailed = 5,
    
    /// SCAN_TIMEOUT
    ///
    /// @note This value only available when  the `operatingMode` of  `AAIGlobalIQAConfig`  is "AAIIQAOperatingModeScanning".
    AAIIQAErrorCodeScanTimeout = 6,
};

typedef NS_ENUM(NSInteger, AAIIQAOrientation) {
    /// The orientation of the SDK page will be automatically rotated according to the orientation of the device.
    AAIIQAOrientationAuto,
    
    /// The orientation of the SDK page will be fixed to landscape orientation.
    AAIIQAOrientationLandscape,
    
    /// The orientation of the SDK page will be fixed to portrait orientation.
    AAIIQAOrientationPortrait
};

typedef NS_ENUM(NSInteger, AAIIQADetectionTimeoutDisposition) {
    /// Switch to photo mode when detection timeout.
    /// @note This value only works when the `operatingMode` of  `AAIGlobalIQAConfig` is "AAIIQAOperatingModeDefault".
    AAIIQADetectionTimeoutDispositionUsePhotoMode = 0,
    
    /// Retry scanning when detection timeout. If the remaining available scan times is greater than zero, the SDK will enter scan mode again and restart timer.
    /// Otherwise, the SDK will go to the photo page or end the SDK flow based on your configurations.
    AAIIQADetectionTimeoutDispositionRetry = 1
};

typedef NS_ENUM(NSInteger, AAIIQADetectionSuccessDisposition) {
    AAIIQADetectionSuccessDispositionDefault = 0
};

#endif
