//
//  AAIIQACameraWrapperView.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2024/5/22.
//

#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>
#import <AAIGlobalIQASDK/AAIIQAConstant.h>
#import <AAIGlobalIQASDK/AAIIQACameraWrapperViewDelegate.h>
#import <AAIGlobalIQASDK/AAIIQACameraWrapperViewConfig.h>

NS_ASSUME_NONNULL_BEGIN
__attribute__((visibility("default")))
@interface AAIIQACameraWrapperView : UIView

/**
 Starts the camera in scan mode.
 
 @param config Configuration options for scan mode.
 @param delegate Delegate object to receive callbacks during the scanning process.
 
 @return An eventId string used to track this flow.
 */
- (NSString *)startScanModeWithConfig:(AAIIQACameraWrapperViewScanConfig *)config delegate:(id<AAIIQACameraWrapperViewScanModeDelegate>)delegate;

/**
 Starts the camera in photo mode.

 @param config Configuration options for photo mode.
 @param delegate Delegate object to receive callbacks during the photo mode process.
 @return An eventId string used to track this flow.

 @Note After calling this method, you can call `capturePhoto` to take a photo.
*/
- (NSString *)startPhotoModeWithConfig:(AAIIQACameraWrapperViewPhotoConfig *)config delegate:(id<AAIIQACameraWrapperViewPhotoModeDelegate>)delegate;

/**
 Stops the camera
 */
- (void)stopRunning;

/**
 Checks if the camera is running
 */
- (BOOL)isRunning;

/**
 Indicates whether the current camera is in scan mode.
 
 
 `YES` means scan mode, i.e., the camera was started by calling the `startScanModeWithConfig:delegate:` method;
 
 `NO` means photo mode, i.e., the camera was started by calling the `startPhotoModeWithConfig:delegate:` method;
*/
@property(nonatomic, readonly) BOOL scanMode;

#pragma mark - photo mode

/**
 Takes a photo.
 After this method is called, the delegate method `iqaOnCapturePhotoDone:previewImage:` will be called once the photo capture is complete.
 You can then call `dropCapturedPhoto` to discard the captured photo, or call `useCapturedPhoto` to use the captured photo.
 
 @note This method can only be used when `scanMode` is NO, otherwise this method call is invalid.
*/
- (void)capturePhoto;

/**
 Uses the captured photo.
 After calling this method, the SDK will upload necessary data, and the delegate method `iqaOnPhotoModeComplete:` will be called upon successful upload.
 
 @note You should always get the captured original image from `iqaOnPhotoModeComplete:`.
       this method can only be used when `scanMode` is NO, otherwise this method call is invalid.
*/
- (void)useCapturedPhoto;

/**
 Discards the captured photo.
 After calling this method, the current view will display the real-time camera preview screen again, and if necessary, you can call `capturePhoto` to take a photo again.

 @Note This method can only be used when `scanMode` is NO, otherwise this method call is invalid.
*/
- (void)discardCapturedPhoto;

#pragma mark - camera position

/**
 Get available cameras positions

 @return An array of type AVCaptureDevicePosition
*/
+ (nullable NSArray *)avaliableCameraPositions;

@property(nonatomic) AVCaptureDevicePosition currCameraPosition;

#pragma mark - flash

/**
 Check if the flashing light is available

 @return YES indicates that the flash-off light is available, NO indicates that the flash-off light is unavailable or does not exist
 */
@property(nonatomic, readonly) BOOL flashAvailable;

@property(nonatomic) AVCaptureTorchMode flashMode;

#pragma mark - Transition orientation

- (void)willTransitionToOrientation:(UIDeviceOrientation)orientation;

@end

NS_ASSUME_NONNULL_END
