//
//  AAICustomTipView2.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/30.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomTipView2: UIView {
    private var _contentView: UIView?
    private var _descLabel: UILabel?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.createSubviews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func createSubviews() {
        let contentView = self.createContentView()
        
        // You can adjust the contentHeight to meet your needs.
        var marginLeft: CGFloat = 12
        let contentHeight: CGFloat = 80
        if let marginLeftObj = AAIGlobalIQASDK.sdkConfig().uiConfig.cameraViewMarginLRInPortraitMode {
            marginLeft = CGFloat(marginLeftObj.floatValue)
        }
        self.addSubview(contentView)
        
        let screenSize = UIScreen.main.bounds.size
        let sw = min(screenSize.width, screenSize.height)
        let allCons: [NSLayoutConstraint] = [
            contentView.widthAnchor.constraint(equalToConstant: (sw - 2 * marginLeft)),
            contentView.heightAnchor.constraint(equalToConstant: contentHeight),
            
            contentView.centerXAnchor.constraint(equalTo: self.centerXAnchor),
            contentView.centerYAnchor.constraint(equalTo: self.centerYAnchor)
        ]
        NSLayoutConstraint.activate(allCons)
        
        _contentView = contentView
    }
    
    private func createContentView() -> UIView {
        let uiConfig = AAIGlobalIQASDK.sdkConfig().uiConfig
        let contentView = UIView()
        contentView.translatesAutoresizingMaskIntoConstraints = false
        contentView.layer.cornerRadius = 8
        
        // You can adjust the font, textColor to meet your needs.
        let label = UILabel()
        label.font = AAIIQACommUtil.font(withSize: 14, isBold: false)
        label.textColor = uiConfig.primaryTextColor
        label.numberOfLines = 0
        label.textAlignment = .center
        label.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(label)
        
        let allCons: [NSLayoutConstraint] = [
            label.leftAnchor.constraint(equalTo: contentView.leftAnchor, constant: 20),
            label.rightAnchor.constraint(equalTo: contentView.rightAnchor, constant: -20),
            label.centerYAnchor.constraint(equalTo: contentView.centerYAnchor),
        ]
        NSLayoutConstraint.activate(allCons)
        
        _descLabel = label
        
        return contentView
    }
    
    func set(bcgColor: UIColor, borderColor: UIColor) {
        _contentView?.backgroundColor = bcgColor
        _contentView?.layer.borderColor = borderColor.cgColor
        _contentView?.layer.borderWidth = 2
    }
}

extension AAICustomTipView2: AAIIQADetectionDelegate {
    func iqa(onDetectionWarn warnCode: AAIIQAWarnCode) {
        // You can adjust the bcgColor, borderColor to meet your needs.
        var stateKey: String?
        switch warnCode {
        case .noCard:
            stateKey = "no_card"
            self.set(bcgColor: UIColor(red: 0.949, green: 0.949, blue: 0.949, alpha: 1), borderColor: UIColor(red: 0.886, green: 0.886, blue: 0.886, alpha: 1))
        case .tooSmallCard:
            stateKey = "too_small_card"
            self.set(bcgColor: UIColor(red: 0.984, green: 0.901, blue: 0.796, alpha: 1), borderColor: UIColor(red: 0.937, green: 0.678, blue: 0.454, alpha: 1))
        case .edgeCross:
            stateKey = "iqa_min_gap_ratio"
            self.set(bcgColor: UIColor(red: 0.984, green: 0.901, blue: 0.796, alpha: 1), borderColor: UIColor(red: 0.937, green: 0.678, blue: 0.454, alpha: 1))
        case .cardPoorQuality:
            stateKey = "iqa_card_poor_quality"
            self.set(bcgColor: UIColor(red: 0.984, green: 0.901, blue: 0.796, alpha: 1), borderColor: UIColor(red: 0.937, green: 0.678, blue: 0.454, alpha: 1))
        case .good:
            stateKey = "hold_phone"
            self.set(bcgColor: UIColor(red: 0.827, green: 0.937, blue: 0.811, alpha: 1), borderColor: UIColor(red: 0.462, green: 0.568, blue: 0.513, alpha: 1))
        case .hasOccluded:
            stateKey = "card_has_occluded"
            self.set(bcgColor: UIColor(red: 0.5, green: 0.937, blue: 0.811, alpha: 1), borderColor: UIColor(red: 0.462, green: 0.568, blue: 0.513, alpha: 1))
        case .unspecified:
            let _ = "";
        @unknown default:
            fatalError("Unknown AAIIQAWarnCode!")
        }
        
        if let stateKey = stateKey {
            _descLabel?.text = AAIIQACommUtil.localStr(forKey: stateKey)
        } else {
            _descLabel?.text = nil
        }
        
    }
    
    func iqa(onDetectionSucceed rawImage: UIImage?) {
        // You can adjust the bcgColor, borderColor to meet your needs.
        self.set(bcgColor: UIColor(red: 0.827, green: 0.937, blue: 0.811, alpha: 1), borderColor: UIColor(red: 0.462, green: 0.568, blue: 0.513, alpha: 1))
        _descLabel?.text = "success"
    }
}
