//
//  BaseDemoViewController.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/29.
//

import UIKit
import AAIGlobalIQAUI

class BaseDemoViewController: UIViewController, UIPickerViewDataSource, UIPickerViewDelegate {
    
    var _tv: UITextView?
    var _reginList: [String] = []
    let _cardTypeList: [AAIIQACardType] = [.idCard, .drivingLicense, .UMID, .SSS, .TIN, .passport, .VOTERID, .NATIONALID, .PRC, .PAGIBIG, .POSTALID]
    let _cardSideList: [AAIIQACardSide] = [.front, .back]
    let _cardTypeStrList: [String] = ["ID_CARD", "DRIVING_LICENSE", "UMID", "SSS", "TIN", "PASSPORT", "VOTERID", "NATIONALID", "PRC", "PAGIBIG", "POSTALID"]
    let _cardSideStrList: [String] = ["FRONT", "BACK"]
    
    let _opModeList: [AAIIQAOperatingMode] = [.default, .scanning, .photo]
    let _opModeStrList: [String] = ["Default", "Scan", "Photo"]
    
    var _currReginIdx: Int = 0
    var _currCardTypeIdx: Int = 0
    var _currCardSideIdx: Int = 0
    var _currOpModeIdx: Int = 0
    
    var reginPV: UIPickerView?
    var cardTypePV: UIPickerView?
    var cardSidePV: UIPickerView?
    var opModePV: UIPickerView?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.backgroundColor = .white
        
        // Load regin list
        let countryListFilePath = Bundle.main.path(forResource: "country_list", ofType: "json")
        guard let countryListData = try? Data(contentsOf: URL(fileURLWithPath: countryListFilePath!)) else {
            return
        }
        guard let countryList = try? JSONSerialization.jsonObject(with: countryListData, options: .mutableContainers) as? [[String: String]] else {
            return
        }
        
        var reginList: [String] = []
        for item in countryList {
            reginList.append(item["iso2Code"]!)
        }
        _reginList = reginList
        
        let reginPV = self.addPV(frame: .zero, tag: 1)
        let cardTypePV = self.addPV(frame: .zero, tag: 2)
        let cardSidePV = self.addPV(frame: .zero, tag: 3)
        let opModePV = self.addPV(frame: .zero, tag: 4)
        
        let btnTitle = "\(AAIGlobalIQASDK.sdkVersion()) Test"
        let btn = self.button(btnTitle, .zero, #selector(tapSDKBtnAction))
        self.view.addSubview(btn)
        
        let tv: UITextView = UITextView(frame: .zero)
        tv.isEditable = false
        tv.font = UIFont.systemFont(ofSize: 14)
        self.view.addSubview(tv)
        _tv = tv
        
        self.view.addSubview(opModePV)
        opModePV.translatesAutoresizingMaskIntoConstraints = false
        
        guard let sv = self.view else {
            return
        }
        let stackView: UIStackView = UIStackView(arrangedSubviews: [reginPV, cardTypePV, cardSidePV])
        stackView.axis = .horizontal
        stackView.distribution = .fillProportionally
        stackView.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(stackView)
        
        btn.translatesAutoresizingMaskIntoConstraints = false
        tv.translatesAutoresizingMaskIntoConstraints = false
        
        let pvCons: [NSLayoutConstraint] = [
            stackView.leftAnchor.constraint(equalTo: sv.leftAnchor, constant: 8),
            AAIIQACommUtil.topContraint(of: stackView, toSV: sv, constant: 0),
            stackView.heightAnchor.constraint(equalToConstant: 88),
            stackView.rightAnchor.constraint(equalTo: sv.rightAnchor, constant: -8),
            
            opModePV.topAnchor.constraint(equalTo: stackView.bottomAnchor, constant: 8),
            AAIIQACommUtil.leftContraint(of: opModePV, toSV: sv, constant: 8),
            opModePV.widthAnchor.constraint(equalToConstant: 140),
            opModePV.heightAnchor.constraint(equalToConstant: 88),
            
            btn.topAnchor.constraint(equalTo: opModePV.bottomAnchor, constant: 8),
            btn.leftAnchor.constraint(equalTo: opModePV.leftAnchor, constant: 8),
            btn.widthAnchor.constraint(equalToConstant: 140),
            btn.heightAnchor.constraint(equalToConstant: 40),
            
            tv.topAnchor.constraint(equalTo: btn.bottomAnchor, constant: 8),
            tv.leftAnchor.constraint(equalTo: sv.leftAnchor, constant: 8),
            tv.rightAnchor.constraint(equalTo: sv.rightAnchor, constant: -8),
            tv.bottomAnchor.constraint(equalTo: sv.bottomAnchor, constant: -8),
        ]
        NSLayoutConstraint.activate(pvCons)
        
        self.reginPV = reginPV
        self.cardTypePV = cardTypePV
        self.cardSidePV = cardSidePV
        self.opModePV = opModePV
    }
    
    func button(_ title: String, _ frame: CGRect, _ action: Selector) -> UIButton {
        let btn = UIButton(type: .custom)
        btn.frame = frame
        btn.setTitle(title, for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.addTarget(self, action: action, for: .touchUpInside)
        btn.backgroundColor = .gray
        return btn
    }
    
    func addPV(frame: CGRect, tag: Int) -> UIPickerView {
        let pv = UIPickerView(frame: frame)
        pv.layer.borderWidth = 1
        pv.layer.borderColor = UIColor.lightGray.cgColor
        pv.tag = tag
        pv.dataSource = self
        pv.delegate = self
        
        self.view.addSubview(pv)
        return pv
    }
    
    @objc func tapSDKBtnAction() {
        
    }
    
    func btnTitle() -> String {
        return "\(AAIGlobalIQASDK.sdkVersion()) Test"
    }
    
    func processIQAResult(_ result: AAIGlobalIQAResult) {
        var resultStr: String = ""
        if (result.success) {
            resultStr.append("SUCCESS")
            resultStr.append("\n\nImage Size:\(result.cardImg?.size.debugDescription ?? "")")
            resultStr.append("\n\nIDVID:\(result.idvid ?? "")")
            resultStr.append("\n\ntransacitonID:\(result.transactionId ?? "")")
            resultStr.append("\n\nPictureType:\(result.pictureType ?? "")")
            
            if let finalImgBase64Str = result.cardImgBase64String {
                if let finalImgData = Data(base64Encoded: finalImgBase64Str) {
                    resultStr.append("\n\nFinalImgSize:\(Float(finalImgData.count / 1024))KB")
                }
            }
            
            if let ocrResult = result.ocrResult {
                if let jsonData = try? JSONSerialization.data(withJSONObject: ocrResult, options: .prettyPrinted) {
                    let jsonStr = String(data: jsonData, encoding: .utf8) ?? ""
                    resultStr.append("\n\nOCRResult:\n\(jsonStr)")
                }
            }
            
            if let idForgeryResult = result.idForgeryResult {
                if let jsonData = try? JSONSerialization.data(withJSONObject: idForgeryResult, options: .prettyPrinted) {
                    let jsonStr = String(data: jsonData, encoding: .utf8) ?? ""
                    resultStr.append("\n\nidForgeryResult:\n\(jsonStr)")
                }
            }
            
            saveImageToPhoto(result.cardImg!)
        } else {
            if let errorCode = result.errorCode {
                resultStr.append("Error Code:\(errorCode)")
            }
            
            if let errorMsg = result.errorMsg {
                resultStr.append("\n\nError Msg:\(errorMsg)")
            }
            if let transactionId = result.transactionId {
                resultStr.append("\n\ntransacitonID:\(transactionId)")
            }
        }
        
        _tv?.text = resultStr;
    }
    
    func saveImageToPhoto(_ img: UIImage) {
        UIImageWriteToSavedPhotosAlbum(img, nil, nil, nil)
    }
    
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        switch pickerView.tag {
        case 1:
            return _reginList.count
        case 2:
            return _cardTypeList.count
        case 3:
            return _cardSideList.count
        case 4:
            return _opModeList.count
        default:
            return 0
        }
    }
    
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        switch pickerView.tag {
        case 1:
            return _reginList[row]
        case 2:
            return _cardTypeStrList[row]
        case 3:
            return _cardSideStrList[row]
        case 4:
            return _opModeStrList[row]
        default:
            return nil
        }
    }
    
    func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int) {
        switch pickerView.tag {
        case 1:
            _currReginIdx = row
        case 2:
            _currCardTypeIdx = row
        case 3:
            _currCardSideIdx = row
        case 4:
            _currOpModeIdx = row
        default: break
        }
    }
    
}


