//
//  AAIGlobalIQASDKCore.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/9/21.
//
#import <Foundation//Foundation.h>

NS_ASSUME_NONNULL_BEGIN
__attribute__((visibility("default")))
@interface AAIGlobalIQASDK : NSObject

/**
 This method is used to initialize the SDK, you must call this method before using the SDK.
 */
+ (void)initSDK NS_SWIFT_NAME(initSDK());

/**
 This method is used to set the license content.
 
 @param license license content
 @return error infomation. "SUCCESS" means the verification license passed; "LICENSE_EXPIRE" means the license is expired; "APPLICATION_ID_NOT_MATCH"  means your app bundle identifier does not match the license.
 
 The license content is obtained by your server calling our openapi.
 If the license verification is passed, the SDK will cache the license information in memory, that is, you only need to call this method once, after that you can directly display the liveness page, no need to call this method again.
 If you call this method every time before the AAILivenessViewController page is displayed, that's fine.
 */
+ (NSString *)setLicenseAndCheck:(NSString *)license;

+ (void)bindUser:(NSString *)userId;

+ (NSString *)sdkVersion;

@end

NS_ASSUME_NONNULL_END

