//
//  AAIIQACameraWrapperViewDelegate.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2024/5/24.
//

#ifndef AAIIQACameraWrapperViewDelegate_h
#define AAIIQACameraWrapperViewDelegate_h

#import <Foundation/Foundation.h>
#import <AAIGlobalIQASDK/AAIIQAConstant.h>
#import <AAIGlobalIQASDK/AAIGlobalIQAResultProtocol.h>


NS_ASSUME_NONNULL_BEGIN

@protocol AAIIQACameraWrapperViewOrientationDelegate<NSObject>
@optional

- (AVCaptureVideoOrientation)iqaPreferredVideoOrientation;

@end

@protocol AAIIQACameraWrapperViewAuthDelegate<NSObject>
@optional

/**
 Tell the delegate object the SDK will begin auth check request.
 
 @note Generally you can implement this method to show your own loading view.
 */
- (void)iqaOnAuthCheckStart;

/**
 Tell the delegate object the SDK upload data done(success or failure). Generally you can implement this method to dismiss your own loading view.
 
 @param error An error object indicating auth check request failed.
 @note If auth check request failed, after this method called, either `iqaOnScanModeComplete:` or `iqaOnPhotoModeComplete:` will also be called.
 */
- (void)iqaOnAuthCheckFinish:(NSError * _Nullable)error;

/**
 Tell the delegate object the SDK will begin upload data.
 
 @note Generally you can implement this method to show your own loading view.
 */
- (void)iqaOnUploadDataStart;

/**
 Tell the delegate object the SDK upload data done(success or failure). Generally you can implement this method to dismiss your own loading view.
 
 @param error An error object indicating request failed.
 @note The delegate method simply indicates the completion (success or failure) of the upload data request.  After this method called, either `iqaOnScanModeComplete:` or `iqaOnPhotoModeComplete:` will be called. If you want to obtain success or failure details, implement the `iqaOnScanModeComplete:` or `iqaOnPhotoModeComplete:` methods directly.
 */
- (void)iqaOnUploadDataFinish:(NSError * _Nullable)error;

@end


@protocol AAIIQACameraWrapperViewScanModeDelegate<AAIIQACameraWrapperViewAuthDelegate, AAIIQACameraWrapperViewOrientationDelegate>
@optional

/**
 This method is called each time after `startScanModeWithConfig:delegate:` is invoked, and the camera has been successfully opened.
 
 @note This method won't be called if the camera fails to open or if there is no permission, instead `iqaOnScanModeComplete:` will be called immediately.
 */
- (void)iqaOnScanModeStart;

/**
 This method is called when the `warnCode` changes during the scanning process. You can displays different warning messages based on the specific warnCode.
 */
- (void)iqaOnScanWarnCodeChanged:(AAIIQAWarnCode)warnCode;

/**
 Tell the delegate object that the remaining scan time has changed.
 */
- (void)iqaOnScanRemainingSecondsChanged:(NSInteger)remainSeconds totalSeconds:(NSInteger)totalSeconds;

/**
 Tell the delegate scanning success.
 
 @param rawImage Reserved field, currently this value is always nil.
 @param previewImage The preview image, note it is different and smaller size than the captured original image.

 @note After SDK scan success, SDK will upload necessary data, after upload done(regardless of success or failure), the delegate method `iqaOnScanModeComplete:` will be called.
 */
- (void)iqaOnScanSuccess:(UIImage * _Nullable)rawImage previewImage:(UIImage *)previewImage;

@required

/**
 Tell the delegate object that the current scanning process has completed (regardless of success or failure).
 This method is always called after a detection process is completed.
 
 @param result The detection result.
 
 @note
    Regardless of success or failure, you should always implement this method to obtain the final scanning result.
    For example, you can obtain the captured document image when scanning process success,
    or detailed failure information (such as network request failure, scan timeout, no camera permissions, etc.) when scanning process failure.
 */
- (void)iqaOnScanModeComplete:(id<AAIGlobalIQAResultProtocol>)result;

@end


@protocol AAIIQACameraWrapperViewPhotoModeDelegate<AAIIQACameraWrapperViewAuthDelegate, AAIIQACameraWrapperViewOrientationDelegate>

@optional

/**
 This method is called each time after `startPhotoModeWithConfig:delegate:` is invoked, and the camera has been successfully opened.
 
 @note This method won't be called if the camera fails to open or if there is no permission, instead `iqaOnPhotoModeComplete:` will be called immediately.
 */
- (void)iqaOnPhotoModeStart;

/**
 Tell the delegate photo is catpured done. If you called method `capturePhoto`, this delegate method will be called once the photo capture is done.
 
 @param capturedImage The captured original image. Reserved field, currently this value is always nil. You should obetain this image from `iqaOnPhotoModeComplete`.
 @param previewImage The preview image, note it is different and smaller size than the captured original image.
 */
- (void)iqaOnCapturePhotoDone:(UIImage * _Nullable)capturedImage previewImage:(UIImage *)previewImage;

@required

/**
 Tell the delegate object that the current photo mode process has completed (regardless of success or failure).
 This method is always called after a photo mode process is completed.
 
 @param result The detection result.
 
 @note 
    Regardless of success or failure, you should always implement this method to obtain the final photo result or detailed failure information.
    For example, you can obtain the original captured image when photo mode process success,
    or detailed failure information (such as network request failure, no camera permissions, etc.) when photo mode process failure.
 */
- (void)iqaOnPhotoModeComplete:(id<AAIGlobalIQAResultProtocol>)result;

@end

NS_ASSUME_NONNULL_END

#endif /* AAIIQACameraWrapperViewDelegate_h */
