//
//  AAIGlobalIQAResult.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/19.
//

#import <UIKit/UIKit.h>
#import <AAIGlobalIQASDK/AAIIQAConstant.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief Protocol defining the interface for Global IQA result objects
 * 
 * This protocol defines all the properties that both mutable and immutable 
 * result objects should support. It provides a common interface for accessing
 * result data regardless of mutability.
 */
@protocol AAIGlobalIQAResultProtocol <NSObject>

@property(nonatomic, readonly) BOOL success;
@property(nonatomic, readonly) BOOL pay;
@property(nonatomic, readonly, nullable) NSString *transactionId;
@property(nonatomic, readonly) NSString *eventId;
@property(nonatomic, readonly) AAIIQAErrorCode errorCodeEnumValue;

/**
 *
 * Error code list:
 *
 * @code
 * CAMERA_OPEN_FAILED
 * USER_GIVE_UP
 * DEVICE_NOT_SUPPORT
 * CAMERA_PERMISSION_DENIED
 * MODEL_ERROR
 * NETWORK_REQUEST_FAILED
 * NO_CARD
 * TOO_SMALL_CARD
 * EDGE_CROSS
 * CARD_POOR_QUALITY
 * SCAN_TIMEOUT
 * MODEL_ERROR // Model error. This means that the model file is corrupted or load failed
 * ...(other codes)
 * @endcode
 *
 * @note The code "SCAN_TIMEOUT" appears only when you set the `operatingMode` of `AAIGlobalIQAConfig` to "AAIIQAOperatingModeScanning".
 */
@property(nonatomic, readonly, nullable) NSString *errorCode;
@property(nonatomic, readonly, nullable) NSString *errorMsg;

/**
 * @brief
 * The final output captured card image in base64 format.
 * Note that this image data is suitable for uploading to the server as it has been appropriately compressed.
 * You can also obtain this image by calling server side api 'openapi/face-identity/image-quality-check/v1/query'
 */
@property(nonatomic, readonly, nullable) NSString *cardImgBase64String;

/**
 * @brief
 * The raw output captured card image without any compression.
 
 * @warning
 * Note that this image is generally used for preview purposes.
 * If you want to upload the image to the server, you should use the `cardImgBase64String` property.
 */
@property(nonatomic, readonly, nullable) UIImage *cardImg;

/**
 * @brief
 * The identifier string that corresponds to the captured card image, which can be used to retrieve the image
 * by calling the server side api 'openapi/face-identity/image-quality-check/v1/query'.
 */
@property(nonatomic, readonly, nullable) NSString *IDVID;

@property(nonatomic, readonly, nullable) NSDictionary *idForgeryResult;
@property(nonatomic, readonly, nullable) NSDictionary *ocrResult;

/**
 * This field is used to indicate which mode the image is from, and it has two values: "takePhoto" and "scan".
 * "takePhoto" mean `cardImg` is from photo mode, "scan" mean `cardImg` is from scan mode.
 */
@property(nonatomic, readonly, nullable) NSString *pictureType;

@end


NS_ASSUME_NONNULL_END
