//
//  AAICustomPreviewImgController4.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2023/8/1.
//

import UIKit

import AAIGlobalIQAUI

class AAICustomPreviewImgController4: AAIIQAPreviewImgController {

    override func loadSDKUI() {
        guard let sv = self.view else {
            return
        }
        guard let previewImg = previewImage else {
            return
        }
        
        // Add your custom navBar.
        let navbar = CustomNavBar4()
        navbar.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(navbar)
        navbar.closeBtn?.addTarget(self, action: #selector(tapCloseBtn), for: .touchUpInside)
        
        let navCons: [NSLayoutConstraint] = [
            navbar.topAnchor.constraint(equalTo: sv.topAnchor),
            navbar.leftAnchor.constraint(equalTo: sv.leftAnchor),
            navbar.rightAnchor.constraint(equalTo: sv.rightAnchor),
        ]
        NSLayoutConstraint.activate(navCons)
        
        // Add top label
        let topLabel = UILabel()
        topLabel.font = AAIIQACommUtil.font(withSize: 16, isBold: true)
        topLabel.text = "Front of ID"
        topLabel.textAlignment = .center
        topLabel.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(topLabel)
        
        // Add preview image view
        let previewImgView = UIImageView()
        previewImgView.image = previewImg
        previewImgView.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(previewImgView)
        
        // Add desc label
        let descLabel = UILabel()
        descLabel.font = AAIIQACommUtil.font(withSize: 16, isBold: true)
        descLabel.text = "Is your whole ID document clear and easy to read?"
        descLabel.numberOfLines = 0
        descLabel.textAlignment = .center
        descLabel.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(descLabel)
        
        var marginLeft: CGFloat = 20
        if let marginLR = AAIGlobalIQASDK.sdkConfig().uiConfig.cameraViewMarginLRInPortraitMode {
            marginLeft = CGFloat(marginLR.floatValue)
        }
        
        let retakeBtn = UIButton(type: .custom)
        retakeBtn.setTitle("Retake", for: .normal)
        retakeBtn.setTitleColor(.black, for: .normal)
        retakeBtn.titleLabel?.font = AAIIQACommUtil.font(withSize: 16, isBold: true)
        retakeBtn.layer.borderColor = UIColor.black.cgColor
        retakeBtn.layer.borderWidth = 1
        retakeBtn.layer.cornerRadius = 5
        retakeBtn.addTarget(self, action: #selector(tapRetakeBtn), for: .touchUpInside)
        
        let continueBtn = UIButton(type: .custom)
        continueBtn.setTitle("Looks good", for: .normal)
        continueBtn.setTitleColor(.black, for: .normal)
        continueBtn.titleLabel?.font = AAIIQACommUtil.font(withSize: 16, isBold: true)
        continueBtn.layer.cornerRadius = 5
        continueBtn.backgroundColor = AAIIQACommUtil.color(withHexRGB: 0xF6FF7E, alpha: 1)
        continueBtn.addTarget(self, action: #selector(tapContinueBtn), for: .touchUpInside)
        
        let btnStackView = UIStackView(arrangedSubviews: [retakeBtn, continueBtn])
        btnStackView.axis = .horizontal
        btnStackView.spacing = 8
        btnStackView.distribution = .fillEqually
        btnStackView.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(btnStackView)
        
        // Add bottom encryption description
        let encryDescImgView = UIImageView(image: UIImage(named: "c4_encr_desc"))
        encryDescImgView.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(encryDescImgView)
        
        let cons: [NSLayoutConstraint] = [
            topLabel.topAnchor.constraint(equalTo: navbar.bottomAnchor, constant: 29),
            topLabel.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
            
            previewImgView.topAnchor.constraint(equalTo: topLabel.bottomAnchor, constant: 8),
            previewImgView.leftAnchor.constraint(equalTo: sv.leftAnchor, constant: marginLeft),
            previewImgView.rightAnchor.constraint(equalTo: sv.rightAnchor, constant: -marginLeft),
            previewImgView.heightAnchor.constraint(equalTo: previewImgView.widthAnchor, multiplier: (previewImg.size.height)/(previewImg.size.width)),
            
            descLabel.topAnchor.constraint(equalTo: previewImgView.bottomAnchor, constant: 44),
            descLabel.leftAnchor.constraint(equalTo: previewImgView.leftAnchor),
            descLabel.rightAnchor.constraint(equalTo: previewImgView.rightAnchor),
            
            btnStackView.topAnchor.constraint(equalTo: descLabel.bottomAnchor, constant: 32),
            btnStackView.leftAnchor.constraint(equalTo: previewImgView.leftAnchor),
            btnStackView.rightAnchor.constraint(equalTo: previewImgView.rightAnchor),
            btnStackView.heightAnchor.constraint(equalToConstant: 48),
            
            encryDescImgView.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
            AAIIQACommUtil.bottomContraint(of: encryDescImgView, toSV: sv, constant: -20)
        ]
        NSLayoutConstraint.activate(cons)
    }

    @objc func tapCloseBtn() {
        self.tapNavBackBtnBlk?(self)
    }
    
    @objc func tapRetakeBtn() {
        self.tapRetakeBtnBlk?(self)
    }
    
    @objc func tapContinueBtn() {
        self.tapContinueBtnBlk?(self)
    }
}
