//
//  AAICustomPorTakePhotoTipView2.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/30.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomPorTakePhotoTipView2: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        // You can adjust the font, textColor to meet your needs.
        let uiConfig = AAIGlobalIQASDK.sdkConfig().uiConfig
        let titleLabel = UILabel()
        titleLabel.font = AAIIQACommUtil.font(withSize: 14, isBold: false)
        titleLabel.textColor = uiConfig.takePhotoTipTextColor
        titleLabel.numberOfLines = 0
        titleLabel.textAlignment = .center
        titleLabel.text = "Take the photo manually!"
        titleLabel.translatesAutoresizingMaskIntoConstraints = false
        self.addSubview(titleLabel)
        
        let constr: [NSLayoutConstraint] = [
            titleLabel.topAnchor.constraint(equalTo: self.topAnchor, constant: 11),
            titleLabel.leftAnchor.constraint(equalTo: self.leftAnchor, constant: 11),
            titleLabel.rightAnchor.constraint(equalTo: self.rightAnchor, constant: -11),
            titleLabel.bottomAnchor.constraint(equalTo: self.bottomAnchor, constant: -11),
        ]
        NSLayoutConstraint.activate(constr)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
