//
//  AAICustomDetectionTimeoutAlertView2.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/30.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomDetectionTimeoutAlertView2: UIView {
    
    func createContentView() -> UIView {
        let sv = UIView()
        sv.backgroundColor = .white
        sv.layer.cornerRadius = 6
        sv.layer.masksToBounds = true
        
        // You can adjust the font, textColor to meet your needs.
        let imgView = UIImageView(image: AAIIQACommUtil.img(withName: "advance_iqa_tip_capture"))
        sv.addSubview(imgView)
        
        let titleLabel = UILabel()
        titleLabel.font = AAIIQACommUtil.font(withSize: 14, isBold: true)
        titleLabel.textColor = AAIIQACommUtil.color(withHexRGB: 0x333333, alpha: 1)
        titleLabel.textAlignment = .center
        titleLabel.text = "Time out!"
        sv.addSubview(titleLabel)
        
        let descLabel = UILabel()
        descLabel.font = AAIIQACommUtil.font(withSize: 13, isBold: false)
        descLabel.textColor = AAIIQACommUtil.color(withHexRGB: 0x333333, alpha: 1)
        descLabel.textAlignment = .center
        descLabel.text = "Let's try taking photo manually."
        sv.addSubview(descLabel)
        
        imgView.translatesAutoresizingMaskIntoConstraints = false
        titleLabel.translatesAutoresizingMaskIntoConstraints = false
        descLabel.translatesAutoresizingMaskIntoConstraints = false
        
        let cons: [NSLayoutConstraint] = [
            imgView.topAnchor.constraint(equalTo: sv.topAnchor, constant: 20),
            imgView.widthAnchor.constraint(equalToConstant: 40),
            imgView.heightAnchor.constraint(equalToConstant: 40),
            imgView.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
            
            titleLabel.topAnchor.constraint(equalTo: imgView.bottomAnchor, constant: 20),
            titleLabel.leftAnchor.constraint(equalTo: sv.leftAnchor, constant: 20),
            titleLabel.rightAnchor.constraint(equalTo: sv.rightAnchor, constant: -20),
            
            descLabel.topAnchor.constraint(equalTo: titleLabel.bottomAnchor, constant: 20),
            descLabel.leftAnchor.constraint(equalTo: sv.leftAnchor, constant: 20),
            descLabel.rightAnchor.constraint(equalTo: sv.rightAnchor, constant: -20),
            
            sv.bottomAnchor.constraint(equalTo: descLabel.bottomAnchor, constant: 20)
        ]
        NSLayoutConstraint.activate(cons)
        
        return sv
    }
    
    func showWithAnimation() {
        let contentView = self.createContentView()
        contentView.translatesAutoresizingMaskIntoConstraints = false
        self.addSubview(contentView)
        let cons: [NSLayoutConstraint] = [
            contentView.centerXAnchor.constraint(equalTo: self.centerXAnchor),
            contentView.widthAnchor.constraint(lessThanOrEqualTo: self.widthAnchor, constant: -40),
            contentView.centerYAnchor.constraint(equalTo: self.centerYAnchor)
        ]
        NSLayoutConstraint.activate(cons)
        self.backgroundColor = UIColor.black.withAlphaComponent(0)
        contentView.alpha = 0
        UIView.animate(withDuration: 0.3) {
            self.backgroundColor = UIColor.black.withAlphaComponent(0.4)
            contentView.alpha = 1
        }
        
    }
}
