//
//  AAICustomUIDemo2ViewController.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/30.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomUIDemo2ViewController: BaseDemoViewController {
    override func tapSDKBtnAction() {
        let config = AAIGlobalIQAConfig.initWithRegion(_reginList[_currReginIdx], cardType: _cardTypeList[_currCardTypeIdx], cardSide: _cardSideList[_currCardSideIdx])
        config.delegate = self;
        config.callbackAfterPageDismissed = true;
        
        // Configure SDK operation mode
        config.operatingMode = _opModeList[_currOpModeIdx]
        
        // Configure SDK UI
        config.detectionTimeoutInterval = 20
        
        // Customize the SDK font
        config.uiConfig.fontName = "Chalkduster"
        
        // Customize the navigation bar title
        config.uiConfig.navBarAttrTitle = NSAttributedString(string: "", attributes: nil)
        
        // Specify viewfinder(Camera overlay view) color.
        config.uiConfig.viewfinderColor = .red
        
        config.uiConfig.toolButtonThemeColor = .blue
        
        config.uiConfig.takePhotoTipLeftIconVisible = false
        config.uiConfig.takePhotoTipBackgroundColor = .clear
        
        // Customize the tip view styled text in photo mode.
        let paragraphStyle: NSMutableParagraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .center
        guard let customFont: UIFont = UIFont(name: config.uiConfig.fontName!, size: 15) else {
            return
        }
        
        config.uiConfig.takePhotoTipAttrText = NSAttributedString(string: "Take Photo manually", attributes: [.paragraphStyle: paragraphStyle, .font: customFont, .foregroundColor: UIColor.red])
        
        config.uiConfig.previewPhotoTipBackgroundColor = .clear
        config.uiConfig.previewPhotoTipLeftIconVisible = false
        config.uiConfig.previewPhotoTipAttrText = NSAttributedString(string: "Please ensure that all data on your documents is visible and readable.", attributes: [.paragraphStyle: paragraphStyle, .font: customFont, .foregroundColor: UIColor.red])
        
        /*
        // Specify SDK language
        config.languageLprojName = "id"
        */
        
        config.uiConfig.cameraViewMarginLRInPortraitMode = 12
        config.uiConfig.flipCameraBtnVisible = false
        config.uiConfig.lightBtnVisible = false
        config.uiConfig.timerLabelVisible = false
        
        
        // Hide the default topDescView and add our own custom topDescView to the "AAICustomScanController2" class.
        config.uiConfig.topDescViewVisible = false
        
        // Customize the "AAIIQAScanController" by specify the class "AAICustomScanController2" (which inherits from "AAIIQAScanController").
        config.register(AAICustomScanController2.self, for: .scanController)
        
        // Customize the viewfinder(camera overlay view) style in scan mode.
        config.register(AAICustomOverlayView2.self, for: .overlayViewOfScanVC)
        
        // Customize the viewfinder(image overlay view) style in preview mode.
        config.register(AAICustomOverlayView2.self, for: .overlayViewOfPreviewImgVC)
        
        // Specify the tipViewDataSource to provide your custom tipView(in scan mode).
        config.tipViewDataSource = self
        
        /*
        // <AAIIQATakePhotoTipViewDataSource>
        // If the ui configuration available for the tipView in photo mode does not meet your needs,
        // you can create a tip view by specifying this property.
        config.takePhotoTipViewDataSource = self
        */
        
        /* imageName list:
        advance_iqa_scan: An image to show the scan animation.
        advance_iqa_tip_capture: The icon in the countdown pop-up view after the scan times out.
        iqa_back: Icon of navigation bar back button.
        iqa_land_confirm: Confirm button icon in landscape take photo mode.
        iqa_land_retake: Retake button icon in landscape take photo mode.
        iqa_light_off: Icon of flashlight off button.
        iqa_light_on: Icon of flashlight on button.
        iqa_scan_processing: The icon displayed at the bottom of the vertical screen (local string key is: "hold_phone").
        iqa_scan_successfully: The icon displayed at the bottom of the vertical screen (local string key is: "iqa_scan_successfully").
        iqa_scan_warning: The icon displayed at the bottom of the vertical screen (local string key is: "iqa_card_poor_quality").
        iqa_take_photo_tip: The tip icon displayed at the bottom of the viewfinder view (local string key is: "iqa_take_photo_tips").
        iqa_take_photo: Icon of take photo button.
        iqa_transform_camera: Icon of switch camera button.
        */
        /*
        // You can implement this block to customize the images used in the SDK.
        config.uiConfig.loadImage = {(imgName, img) -> UIImage in
            if imgName == "iqa_scan_successfully" {
                return UIImage(named: "ok")!
            }
            return img
        }
        */
        
        /*
        // You can implement this block to customize the localized strings used in the SDK.
        // For all available keys, see "AAIGlobalIQASDK.framework/Assets.bundle/AAIIQALanguageString.bundle/en.lproj/Localizable.strings"
        config.uiConfig.loadLocalizedString = {(key, value, language) -> String in
            if key == "iqa_top_desc" && language == "en" {
                return "My test string"
            }
            
            return value
        }
         */
        
        // 2. Init SDK
        AAIGlobalIQASDK.initWith(config);
        /*
         The license content is obtained by your server calling our openapi.
         In order to demonstrate this SDK, we directly put the content of the license into the file,
         in fact, you should call your server api to get the license content.
         Note that the "setLicenseAndCheck" method MUST BE CALLED before calling "start(WithRootVC:)".
         */
        guard let path = Bundle.main.path(forResource: "SDK-DEMO-LICENSE.txt", ofType: nil) else {
            print("SDK-DEMO-LICENSE file not exist!")
            return
        }
        var demoLicenseContent = ""
        do {
            var content = try String(contentsOfFile:path, encoding: String.Encoding.utf8)
            content = content.trimmingCharacters(in: .whitespacesAndNewlines)
            demoLicenseContent = content
        } catch {}

        let result = AAIGlobalIQASDK.setLicenseAndCheck(demoLicenseContent)
        if result == "SUCCESS" {
            // 3. Show SDK page
            AAIGlobalIQASDK.start(withRootVC: self)
        } else {
            _tv?.text = result
            if result == "LICENSE_EXPIRE" {
                print("LICENSE_EXPIRE: please call your server's api to generate a new license")
            } else if result == "APPLICATION_ID_NOT_MATCH" {
                print("APPLICATION_ID_NOT_MATCH: please bind your app's bundle identifier on our cms website, then recall your server's api to generate a new license")
            } else {
                print("\(result)")
            }
        }
        
        
    }
}

extension AAICustomUIDemo2ViewController: AAIGlobalIQADelegate {
    func iqa(onDetectionComplete result: AAIGlobalIQAResult) {
        processIQAResult(result)
    }
    
    /*
    // You implement this method to add your own custom processing
    func iqa(onDectionSuccess contentView: UIView, completionHandler: @escaping () -> Void) {
        // You can add your own custom processing,
        // such as animated pop-ups to indicate successful detection,
        // after your processing is complete, you must call the completionHandler()
        completionHandler()
    }
     */
    
    /*
    // If you want to customize the timeout alert view, you can implement this method to display your own timeout alert view.
    func iqa(onDetectionTimeout contentView: UIView, completionHandler: @escaping (AAIIQADetectionTimeoutDisposition) -> Void) {
        let alertView = AAICustomDetectionTimeoutAlertView2()
        alertView.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(alertView)
        let cons: [NSLayoutConstraint] = [
            alertView.topAnchor.constraint(equalTo: contentView.topAnchor),
            alertView.leftAnchor.constraint(equalTo: contentView.leftAnchor),
            alertView.bottomAnchor.constraint(equalTo: contentView.bottomAnchor),
            alertView.rightAnchor.constraint(equalTo: contentView.rightAnchor),
        ]
        NSLayoutConstraint.activate(cons)
        alertView.showWithAnimation()
        
        DispatchQueue.main.asyncAfter(deadline: .now()+3) {
            alertView.removeFromSuperview()
            completionHandler(.usePhotoMode)
        }
    }
     */
    
}

// Required methods for protocol <AAIIQATipViewDataSource>.
extension AAICustomUIDemo2ViewController: AAIIQATipViewDataSource {
    func iqaCreateTipView(_ isPortratOrientation: Bool) -> (UIView & AAIIQADetectionDelegate)? {
        // Here we take only custom tipView in protrait mode as an example
        if isPortratOrientation {
            return AAICustomTipView2()
        } else {
            // Use default tip view in landscape mode
            return nil
        }
    }
}

/*
// Required methods for protocol <AAIIQATakePhotoTipViewDataSource>.
extension AAICustomUIDemo2ViewController: AAIIQATakePhotoTipViewDataSource {
    func iqaCreateTakePhotoTipView(_ isPortratOrientation: Bool) -> UIView? {
        if isPortratOrientation {
            return AAICustomPorTakePhotoTipView2()
        } else {
            // Use default take photo tip view in landscape mode
            return nil
        }
    }
}
 */
 
