//
//  AAICustomOverlayView1.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/7/4.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomOverlayView1: AAIIQAOverlayView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        // You can add your custom subviews. For example, add an image view.
        // Or you can override the `drawRect:` method to draw your custom graph.
        // Because the super class AAIIQAOverlayView draw the viewfinder in `drawRect:` method,
        // if you don't want the default viewfinder style, you should always override the `drawRect:` method.
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // You can override the `drawRect` method to draw your custom graph.
    override func draw(_ rect: CGRect) {
        let context = UIGraphicsGetCurrentContext()
        
        let lineWidth: CGFloat = 1.0
        context?.saveGState()
        context?.setFillColor(self.maskColor.cgColor)
        
        let maskPath: UIBezierPath = UIBezierPath(rect: rect)
        let innerRect = rect
        let innerRectPath = UIBezierPath(roundedRect: innerRect, cornerRadius: 8)
        maskPath.append(innerRectPath)
        maskPath.usesEvenOddFillRule = true
        
        context?.addPath(maskPath.cgPath)
        context?.fillPath(using: .evenOdd)
        context?.restoreGState()
        
        context?.setLineWidth(lineWidth)
        context?.setLineCap(.square)
        context?.addPath(innerRectPath.cgPath)
        context?.setStrokeColor(UIColor.red.cgColor)
        context?.strokePath()
    }

}
