//
//  AAICameraViewDemo1ViewController.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2024/5/24.
//

import Foundation
import AAIGlobalIQASDK
import AAIGlobalIQAUI

class AAICameraViewDemo1ViewController : BaseDemoViewController {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.reginPV?.isHidden = true
        self.cardTypePV?.isHidden = true
        self.cardSidePV?.isHidden = true
        self.opModePV?.isHidden = true
    }
    
    override func tapSDKBtnAction() {
        // Init SDK
        AAIGlobalIQASDK.initSDK()
        
        // bind user id
        // This is a optional step.
        // If you need to track the issue, you can call this method to bind a
        // user identifier or other reference identifier to help us locate the issue.
        AAIGlobalIQASDK.bindUser("your-user-id")
        
        /*
         The license content is obtained by your server calling our openapi.
         In order to demonstrate this SDK, we directly put the content of the license into the file,
         in fact, you should call your server api to get the license content.
         Note that the "setLicenseAndCheck" method MUST BE CALLED before calling "start(WithRootVC:)".
         */
        
        guard let path = Bundle.main.path(forResource: "SDK-DEMO-LICENSE.txt", ofType: nil) else {
            print("SDK-DEMO-LICENSE file not exist!")
            return
        }
        var demoLicenseContent = ""
        do {
            var content = try String(contentsOfFile:path, encoding: String.Encoding.utf8)
            content = content.trimmingCharacters(in: .whitespacesAndNewlines)
            demoLicenseContent = content
        } catch {}

        let result = AAIGlobalIQASDK.setLicenseAndCheck(demoLicenseContent)
        if result == "SUCCESS" {
            // 3. Show SDK page
            let myCameraVC = MyCameraDemo1ViewController();
            myCameraVC.completeBlk = { (vc, result) in
                vc.navigationController?.popViewController(animated: true)
                // The class AAIGloabelIQAResult is in the AAIGlobalIQAUI module.
                let finalResult = AAIGlobalIQAResult.copy(fromResult:result)
                self.processIQAResult(finalResult)
            }
            self.navigationController?.pushViewController(myCameraVC, animated: true)
        } else {
            _tv?.text = result
            if result == "LICENSE_EXPIRE" {
                print("LICENSE_EXPIRE: please call your server's api to generate a new license")
            } else if result == "APPLICATION_ID_NOT_MATCH" {
                print("APPLICATION_ID_NOT_MATCH: please bind your app's bundle identifier on our cms website, then recall your server's api to generate a new license")
            } else {
                print("\(result)")
            }
        }
        
    }
    
    
}




