//
//  AAIIQACameraWrapperViewConfig.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2024/5/28.
//

#import <Foundation/Foundation.h>
#import <AAIGlobalIQASDK/AAIIQAConstant.h>
#import <AVFoundation/AVCaptureSessionPreset.h>
#import <AAICore/AAICConstant.h>

typedef NS_ENUM(NSInteger, AAIIQACameraPreset) {
    /// Optimal preset for the current device
    AAIIQACameraPresetOptimal = 0,
    
    /// 4K UHD preset (AVCaptureSessionPreset3840x2160), if the device does not support this preset, it will automatically use the optimal preset
    AAIIQACameraPresetUHD4K = 1
};

NS_ASSUME_NONNULL_BEGIN
__attribute__((visibility("default")))
@interface AAIIQACameraWrapperViewBaseConfig : NSObject

/// Regional ISO code, you can use 2-digit or 3-digit shortcode, see Wikipedia https://zh.wikipedia.org/wiki/ISO_3166-1
@property(nonatomic, copy) NSString *region;

@property(nonatomic) AAIIQACardType cardType;
@property(nonatomic) AAIIQACardSide cardSide;

/// Whether to return null value on fields that recognized as empty, defaults is NO.
@property(nonatomic) BOOL returnEmptyOfOCR;

/// @warning Experimental configuration field. May be modified or removed in the future.
/// Normally you should not setting this field.
@property(nonatomic) CGFloat edgeMinGapRatioThreshold;

/// @warning Experimental configuration field. May be modified or removed in the future.
/// Normally you should not setting this field.
@property(nonatomic) CGFloat paddingRatio;

/// @warning Experimental configuration field. May be modified or removed in the future.
/// Normally you should not setting this field.
@property(nonatomic) NSInteger pictureMaxSize;

/// Preferred session preset for camera, defaults is AAIIQACameraPresetOptimal.
@property(nonatomic) AAIIQACameraPreset preferredCameraPreset;

@property(nonatomic, copy, nullable) NSString *userId;

@property(nonatomic) AAICPluginType pluginType;

@end


__attribute__((visibility("default")))
@interface AAIIQACameraWrapperViewScanConfig : AAIIQACameraWrapperViewBaseConfig

/// Detection timeout interval in seconds. Default is 20s.
@property(nonatomic) NSUInteger detectionTimeoutInterval;

@end

__attribute__((visibility("default")))
@interface AAIIQACameraWrapperViewPhotoConfig : AAIIQACameraWrapperViewBaseConfig

@end

NS_ASSUME_NONNULL_END
